/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.PWMParameter;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo5;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.MessageMemoryRTF;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.awt.Point;
import java.util.Map;

public class LinkerToLogo6
extends LinkerToLogo5 {
    public LinkerToLogo6(Hardware hw) {
        super(hw);
    }

    public Object visit(ClockParameter param) {
        int i;
        int[] days = new int[3];
        int size = param.getCamCount();
        for (i = 0; i < size; ++i) {
            int[] time;
            CamParameter cam = param.getCam(i);
            if (cam.getOnTime().isInactive()) {
                this.fMemory.put(255);
                this.fMemory.put(255);
            } else {
                time = cam.getOnTime().getLogoTime();
                this.fMemory.put(time[1]);
                this.fMemory.put(time[0]);
            }
            if (cam.getOffTime().isInactive()) {
                this.fMemory.put(255);
                this.fMemory.put(255);
            } else {
                time = cam.getOffTime().getLogoTime();
                this.fMemory.put(time[1]);
                this.fMemory.put(time[0]);
            }
            days[i] = cam.getAvailableModes()[cam.getMode()].getLogoMode();
        }
        for (i = 0; i < days.length; ++i) {
            this.fMemory.put(days[i]);
        }
        this.fMemory.put(param.getPulse() != false ? 1 : 0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(YearClockParameter param) {
        int[] logoValue = param.getOnTime().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(logoValue[0]);
        this.fMemory.put(param.getOnYear().getCurrentValue() - param.getYearStart());
        logoValue = param.getOffTime().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(logoValue[0]);
        this.fMemory.put(param.getOffYear().getCurrentValue() - param.getYearStart());
        int modeByte = 0;
        if (param.getPulse().booleanValue()) {
            modeByte |= 1;
        }
        if (param.isYearly().booleanValue()) {
            modeByte |= 0x40;
        }
        if (param.isEveryMonth()) {
            modeByte |= 0x80;
        }
        this.fMemory.put(modeByte);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogMathsParameter param) {
        this.writeWordOrReference(param.getP1Properties());
        this.writeWordOrReference(param.getP2Properties());
        this.writeWordOrReference(param.getP3Properties());
        this.writeWordOrReference(param.getP4Properties());
        int mode = 3 & param.getEnOutputOptionID();
        for (int i = 0; i < param.getOpNum(); ++i) {
            this.fMemory.put(param.getOperator(i));
            mode <<= 2;
            mode += 3 & param.getOpPRI(param.getOpNum() - i - 1);
        }
        this.fMemory.put(mode);
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(255);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(MathDetectionParameter param) {
        int progNr = 255;
        if (param.getReferencedBlockNumber() > 0) {
            progNr = this.convertToPrgLine(param.getReferencedBlockNumber());
        }
        this.fMemory.put(progNr);
        this.fMemory.put(param.isAutoResetMode() != false ? 1 : 0);
        this.fMemory.putWord(65535);
        int detectedErr = 0;
        if (param.isDetectOverflow()) {
            ++detectedErr;
        }
        if (param.isDetectZeroDivision()) {
            detectedErr += 2;
        }
        this.fMemory.put(detectedErr);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogComparatorParameter param) {
        this.writeWordOrReference(param.getOnTrigger());
        this.writeWordOrReference(param.getOffTrigger());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogTriggerParameter param) {
        this.writeWordOrReference(param.getOn());
        this.writeWordOrReference(param.getOff());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(StairsSwitchParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.writeTimerOrReference(param.getTimeParamToWarning());
        this.writeTimerOrReference(param.getWarningTimeParam());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(HoursCounterParameter param) {
        this.fMemory.putDoubleWord(param.getOTStart_Minute());
        this.writeLongTimerOrReference(param.getMIProperties());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(param.isOutputIndependentOfEn() != false ? 1 : 0);
        this.fMemory.put(0);
        this.fMemory.putDoubleWord(0);
        this.fMemory.putDoubleWord(0);
        return null;
    }

    public Object visit(CounterParameter param) {
        this.writeDoubleWordOrReference(param.getOn());
        this.writeDoubleWordOrReference(param.getOff());
        this.fMemory.putDoubleWord(param.getStartValue().getCurrentValue());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(PWMParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.putWord(param.getRangeMin());
        this.fMemory.putWord(param.getRangeMax());
        this.fMemory.put(0);
        this.fMemory.put(param.getSensorType());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.putWord(0);
        this.fMemory.putWord(0);
        return null;
    }

    public Object visit(AnalogWatchdogParameter param) {
        this.writeWordOrReference(param.getDeltaTrigger01());
        this.writeWordOrReference(param.getDeltaTrigger02());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public void putMessageTextAndGlobalSetting(MessageParameter param) throws ArrayIndexOutOfBoundsException {
        MessageMemoryRTF msgMemory = (MessageMemoryRTF)((Logo)this.fHardware).getMemory("Message RTF");
        MessageGlobalInfo msgGlobalInfo = param.getBlock().getWiringDiagram().getMessageGlobalInfo();
        int[] charSet = new int[]{msgGlobalInfo.getSelectedCharSet(0), msgGlobalInfo.getSelectedCharSet(1)};
        if (!msgMemory.fGlobalSettingFinished) {
            msgMemory.setCharacterSets(charSet[0], charSet[1]);
            msgMemory.setCharacterSetCur(msgGlobalInfo.getCurCharSetID());
            msgMemory.setTickerInterval(msgGlobalInfo.getTickerInterval());
            msgMemory.setAnalogRefreshInterval(msgGlobalInfo.getAnalogRefreshInterval());
            msgMemory.fGlobalSettingFinished = true;
        }
        if (!param.isRTF()) {
            int textID = param.getMsgNumber();
            MessageParameter.MessageText newText = new MessageParameter.MessageText(textID, 1, param);
            MessageParameterDisplayModelPlain preModel = new MessageParameterDisplayModelPlain(param);
            DisplayElement dispElement = null;
            Point point = new Point();
            for (int y = 0; y < preModel.getDisplayDimension().height; ++y) {
                int x = 0;
                while (x < preModel.getDisplayDimension().width) {
                    point.setLocation(x, y);
                    dispElement = preModel.getElementAt(point);
                    if (dispElement != null) {
                        newText.getMessageLineRTF()[y].setDisplayElement(dispElement, x);
                        x += dispElement.getWidth();
                        continue;
                    }
                    ++x;
                }
            }
            this.downloadOneMessageBlock(msgMemory, textID, param.getMsgNumber(), 0, charSet[0], newText);
        } else {
            for (int i = 0; i < 2; ++i) {
                if (param.getMessageRTF(i) == null) continue;
                int textID = param.getMessageRTF(i).getTextID();
                this.downloadOneMessageBlock(msgMemory, textID, param.getMsgNumber(), i, charSet[i], param.getMessageRTF(i));
            }
        }
    }

    private void downloadOneMessageBlock(MessageMemoryRTF msgMemory, int textID, int messageNumber, int charSetID, int charSet, MessageParameter.MessageText msgText) {
        msgMemory.setMessageTextInfo(textID, messageNumber, charSetID, charSet);
        int messageInfo = msgText.getShowDest();
        messageInfo <<= 1;
        msgMemory.setMsgInfo(textID, messageInfo |= msgText.getTickerType());
        MessageLineRTF[] lines = msgText.getMessageLineRTF();
        for (int j = 0; j < lines.length; ++j) {
            msgMemory.getMessageTextMemory().setPosition(textID * 4 + j, 0);
            this.writeContents(lines[j], msgMemory.getMessageTextMemory());
            msgMemory.setMsgLineTickerFlag(textID, j, lines[j].isTickerLine());
            this.writeBarInfo(lines[j].getBarGraphMap(), msgMemory);
            this.writeNameInfo(lines[j].getIONameMap(), msgMemory);
        }
    }

    protected void writeContents(MessageLineRTF line, MessageMemory8 textMemory) {
        textMemory.put(line.getContentsBytes());
    }

    protected void writeBarInfo(Map barMapLine, MessageMemoryRTF msgMemory) {
        Object[] keys = barMapLine.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            int[] value = (int[])barMapLine.get(keys[i]);
            msgMemory.getBarGraphMemory().setPosition((Integer)keys[i], 0);
            msgMemory.getBarGraphMemory().put(value);
        }
    }

    protected void writeNameInfo(Map nameMapLine, MessageMemoryRTF msgMemory) {
        Object[] keys = nameMapLine.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            int[] value = (int[])nameMapLine.get(keys[i]);
            msgMemory.getIO_StatusNameMemory().setPosition((Integer)keys[i], 0);
            msgMemory.getIO_StatusNameMemory().put(value);
        }
    }

    public Object visit(MessageParameter param) {
        int value = param.getPriority();
        if (param.isReceipt()) {
            value |= 0x80;
        }
        this.fMemory.put(value);
        this.fMemory.put(param.getMsgNumber());
        this.fMemory.put(0);
        this.fMemory.put(param.getBlock().getWiringDiagram().getMessageGlobalInfo().isFUseNewFeature() ? 128 : 0);
        this.putMessageTextAndGlobalSetting(param);
        return null;
    }

    protected void writeLongTimerOrReference(TimeValueProperties value) {
        if (value.isReference()) {
            int[] logoValue = value.getCurrentValue().getLogoTime();
            int aWord = Util.makeWord(logoValue[1], logoValue[0]);
            this.fMemory.putWord(this.convertToPrgLine(aWord));
            this.fMemory.putWord(0);
        } else {
            int[] time = ((UnlimitedHours)value.getCurrentValue()).getLogoTime();
            this.fMemory.put(time[3]);
            this.fMemory.put(time[2]);
            this.fMemory.put(time[1]);
            this.fMemory.put(time[0]);
        }
    }
}

